
module Time = 


(* this function assume t1 >= t2 *)
let diff (t1_sec, t1_nsec) (t2_sec, t2_nsec) = 
  let secdiff = Int64.sub t1_sec t2_sec in 
  if t1_nsec > t2_nsec then 
    (secdiff, t1_nsec - t2_nsec)
  else
    (Int64.sub secdiff 1L, 1000000000 - t2_nsec + t1_nsec)


let compare (t1_sec, t1_nsec) (t2_sec, t2_nsec) = 
  if Int64.compare t1_sec t2_sec > 0 then
    1
  else if Int64.compare t1_sec t2_sec = 0 then
    if t1_nsec > t2_nsec then 
      1
    else if t1_nsec = t2_nsec then
      0
    else 
      -1
  else
    -1
  
  
  
endmodule

